/**
* Script: savestate.js
* Written by: Radnen
* Updated: 12/19/2010
**/

function SaveState(name)
{
	if (!name) name = "SaveState";
	this.inherit = State;
	this.inherit(name);
	
	var list = GetFileList();
	var files = [];
	var file = null;
	
	for (var i = 0; i < list.length; ++i) {
		files[i] = list[i].substr(0, list[i].length-4);
	}
		
	this.x = SW/2-250;
	this.y = SH/2-166;
	
	var c_holder = new ControlHolder(0, 0, SW, SH);
	var panel = new Panel(c_holder, this.x, this.y, SW, SH);
	
	var inputlabel = new Label(panel, "Input Filename:");
	inputlabel.xx = 290;
	inputlabel.yy = 14;
	var inputbox = new InputBox(panel, 290, 34, 200, 22);	
	
	var questitems = new ListBox(panel, 20, 36, 260, 220);
	for (var i = 0; i < files.length; ++i) {
		questitems.addText(files[i], function() {
			inputbox.text = files[Utility.indexOf(files, questitems.item.text)];
		});
	}
		
	var loaditem = new EasyButton("Save", this.x+335, this.y+280);
	loaditem.onClick.add(function(sender) {
		if (inputbox.text.length == 0) {
			Audio.playSound(System.cantSnd);
			return;
		}
		if (Utility.contains(files, inputbox.text)) {
			var s = new YesNoState("Do you want to overwrite: " + inputbox.text + "?");
			s.onOkay.add(function(sender) {
				Audio.playSound(System.clickSnd);
				Genesis.save(inputbox.text);
				inputbox.text = "";
			}, sender);
			s.show();
		}
		else {
			Audio.playSound(System.clickSnd);
			Genesis.save(inputbox.text);
			sender.hide();
		}
	}, this);
	var backitem = new EasyButton("Back", this.x+100, this.y+280);
	backitem.onClick.add(function(sender) {
		Audio.playSound(System.cancelSnd);
		sender.hide();
	}, this);	
	
	this.render.add(function() {
		Resources.images.questmenu.blit(this.x, this.y);
		if (file != null) {
			Rectangle(this.x+290, this.y+12, 200, 230, Colors.clearBlack);
			System.textFont.drawText(this.x+290, this.y+12, file);
		}
		c_holder.draw();
		Rectangle(this.x+24, this.y+16, 260, 20, Colors.clearBlack);
		System.textFont.drawText(this.x+24, this.y+16, "Saved Games:");
		if (files.length == 0)
			System.textFont.drawText(this.x+24, this.y+36, "[No Files Here]");
		loaditem.draw();
		backitem.draw();
	});
	
	this.update.add(function() {
		c_holder.update();
		loaditem.update();
		backitem.update();
	});
	
	this.doInput = function(key) {
		inputbox.doInput(key);
	}
	
	c_holder.controls.push(panel);
	c_holder.focusedControl = panel;
	panel.controls.push(questitems);
	panel.controls.push(inputbox);
	panel.controls.push(inputlabel);
}